% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fit_model_xy.R
\name{copulareg}
\alias{copulareg}
\alias{copulareg.default}
\title{copulareg}
\usage{
copulareg.default(
  y,
  x,
  var_type_y,
  var_type_x,
  family_set = c("gaussian", "clayton", "gumbel"),
  extra_x = NULL,
  extra_y = NULL
)
}
\arguments{
\item{y}{A vector of n observations of the (univariate) outcome variable y}

\item{x}{A (n x p) matrix of n observations of p covariates}

\item{var_type_y}{A character that has to be specified as "d" or "c"
to indicate whether y is discrete or continuous, respectively.}

\item{var_type_x}{A vector of p characters that have to take the value
"c" or "d" to indicate whether each margin of the covariates is discrete
or continuous.}

\item{family_set}{A vector of strings that specifies the set of
pair-copula families that the fitting algorithm chooses from. For an
overview of which values that can be specified, see the documentation for
\link[rvinecopulib]{bicop}.}

\item{extra_x}{Optional extra values of x to use for estimating the
margins of the covariates.}

\item{extra_y}{Optional extra values of y to use to estimate the margin
of y.}
}
\value{
An object of the class 'copulareg', which contains an object of the class
'vinecop', see rvinecopulib::vinecop, an enviroment that stores the transformed
variables at each level of the pair copula for the training data, the marginal 
distributions of the covariates, the marginal distribution of the response,
and the y-training values.
}
\description{
This function fits joint distributions with an R-vine
pair copula structure, that is constructed in a specific way so that
the conditional density and distribution of the variable y can be
computed explicitly.
}
\examples{
# Compile some test data
data('ChickWeight') 
set.seed(10)
tr <- sample(c(TRUE, FALSE), nrow(ChickWeight), TRUE, c(0.7, 0.3))
y_tr <- ChickWeight$weight[tr]
y_te <- ChickWeight$weight[!tr]
x_tr <- apply(ChickWeight[tr, -1], 2, as.numeric)
x_te <- apply(ChickWeight[!tr, -1], 2, as.numeric)
var_type_x <- apply(x_tr, 2,
                    function(x) if(length(unique(x)) < 10) "d" else "c")

# Fit model to training data
md <- copulareg::copulareg(y_tr, x_tr, "c", var_type_x)

# Predict for a new data matrix
pred <- predict(md, new_x = x_te)

# Plot residuals for test data against covariates
plot(data.frame(residual = y_te - pred, x_te))

# Plot residuals against fitted
plot(md)

# Plot prediction error against predicted values
plot(md, new_x=x_te, new_y=y_te)
}
