% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ngon.R
\name{ngon}
\alias{ngon}
\title{Draw a regular n-gon}
\usage{
ngon(x = 0, y = 0, s = 1, n = 6, angle = 0, fix.aspect = TRUE, ...)
}
\arguments{
\item{x}{vector of x-coordinates specifying the centres of the n-gons.}

\item{y}{vector of y-coordinates specifying the centres of the n-gons.}

\item{s}{side lengths; either a single number or a vector of the same length as \code{x} and \code{y}. In log-log plots, the value of s is in units of dex.}

\item{n}{number of sides of the regular n-gons; either a single number or a vector of the same length as \code{x} and \code{y}.}

\item{angle}{rotation angle in radians; either a single number or a vector of the same length as \code{x} and \code{y}.}

\item{fix.aspect}{logical flag. If TRUE (default), the aspect ratio of the n-gon on the screen is forced to be unity, even if the this makes it irregular in the coordinates of the plot. If FALSE, the n-gon is regular in plot coordinates, which makes it distorted in screen coordinates if the aspect ratio is not one and/or if logarithmic coordinates are used.}

\item{...}{additional arguments used by \code{\link[graphics]{polygon}}.}
}
\value{
None.
}
\description{
Draws a regular polygon with n sides, such as a triangle (n=3) or hexagon (n=6).
}
\examples{

## Plot random points on the unit sphere in Mollweide projection
# hexagon at the center of a plot
nplot(bty='o', asp=0.5)
ngon(x=0.5, y=0.5, s=0.1, n=6, fix.aspect=FALSE)

ngon(x=0.5, y=0.5, s=0.1, n=6, border='red')

plot(NA,xlim=c(1,1e3),ylim=c(1,1e5),log='xy')
ngon(x=10^runif(10,0,3), y=10^runif(10,0,5), s=1, n=6,  border='red',lwd=3)

}
\author{
Danail Obreschkow
}
