% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/black_scholes.R
\name{black_schiles}
\alias{black_schiles}
\title{Black Schiles Model function
Calculating Function Using the Black-Schiles Option Pricing Model}
\usage{
black_schiles(
  mode = 1,
  current_price,
  stock_price,
  conver_price,
  stock_var,
  time,
  interest_rate,
  netdebt_value
)
}
\arguments{
\item{mode}{Two calculation methods, respectively 1 and 2}

\item{current_price}{Current price of convertible bonds}

\item{stock_price}{Positive stock price}

\item{conver_price}{Conversion price}

\item{stock_var}{Standard deviation of annualized rate of return for underlying stocks}

\item{time}{Expiration time (annualized remaining period)}

\item{interest_rate}{Risk-free continuous compound interest rate}

\item{netdebt_value}{Pure debt value}
}
\value{
Option value per share(numeric)
}
\description{
Black Schiles Model function
Calculating Function Using the Black-Schiles Option Pricing Model
}
\examples{
result<-black_schiles(mode=1,current_price=122.82,
 stock_price=5.9,conver_price=5.43,stock_var=0.2616,time=1.353,
 interest_rate=0.018482, netdebt_value=104.05)

}
