% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversation_multidyads.R
\name{structural_sim_dyads}
\alias{structural_sim_dyads}
\title{Calculate structural similarity for multiple dyads}
\usage{
structural_sim_dyads(conversations)
}
\arguments{
\item{conversations}{A data frame with columns 'dyad_id', 'speaker', and 'processed_text'}
}
\value{
A list containing structural similarity for each dyad and the overall average similarity
}
\description{
This function calculates an extended measure of structural similarity for multiple dyads.
}
\examples{
convs <- data.frame(
  dyad_id = c(1, 1, 1, 1, 2, 2, 2, 2),
  speaker = c("A", "B", "A", "B", "C", "D", "C", "D"),
  processed_text = c("i love pizza", "me too favorite food",
                     "whats your favorite topping", "enjoy pepperoni mushrooms",
                     "i prefer pasta", "pasta delicious like spaghetti carbonara",
                     "ever tried making home", "yes quite easy make")
)
structural_sim_dyads(convs)
}
