% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversation_sequence.R
\name{sent_sim_seq}
\alias{sent_sim_seq}
\title{Calculate sentiment similarity sequence for a single dyad}
\usage{
sent_sim_seq(conversation, window_size = 3)
}
\arguments{
\item{conversation}{A data frame representing the conversation}

\item{window_size}{An integer specifying the size of the sliding window}
}
\value{
A list containing the sequence of similarities and the average similarity
}
\description{
This function calculates sentiment similarity over a sequence of conversation exchanges within a single dyad.
}
\examples{
conversation <- data.frame(
  processed_text = c("I love this movie!", "It's really amazing.",
                     "The acting is superb.", "I couldn't agree more.")
)
result <- sent_sim_seq(conversation, window_size = 2)
print(result)
}
