% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversation_sequence_utilities.R
\name{radar_sim}
\alias{radar_sim}
\title{Create Radar Chart of Average Similarities}
\usage{
radar_sim(similarities, titles)
}
\arguments{
\item{similarities}{A list of similarity measures for a single dyad}

\item{titles}{A character vector of titles for each similarity measure}
}
\value{
A ggplot object
}
\description{
Create a radar chart of average similarities for a single dyad
}
\details{
This function creates a radar chart of average similarities for multiple measures of a single dyad.
}
\examples{
sim1 <- list(sequence = c(0.5, 0.6, 0.7, 0.6, 0.8), average = 0.64)
sim2 <- list(sequence = c(0.4, 0.5, 0.6, 0.7, 0.7), average = 0.58)
sim3 <- list(sequence = c(0.6, 0.7, 0.8, 0.7, 0.9), average = 0.74)
sim4 <- list(sequence = c(0.3, 0.4, 0.5, 0.6, 0.6), average = 0.48)
similarities <- list(sim1, sim2, sim3, sim4)
titles <- c("Measure 1", "Measure 2", "Measure 3", "Measure 4")

# Create radar chart
radar <- radar_sim(similarities, titles)
print(radar)
}
