% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_functions_utilities.R
\name{gen_sim_report}
\alias{gen_sim_report}
\title{Generate similarity report}
\usage{
gen_sim_report(
  speech1,
  speech2,
  topic_method = "lda",
  semantic_method = "tfidf",
  glove_path = NULL
)
}
\arguments{
\item{speech1}{A character string representing the first speech}

\item{speech2}{A character string representing the second speech}

\item{topic_method}{Method for topic similarity calculation ("lda" or "lsa")}

\item{semantic_method}{Method for semantic similarity calculation ("tfidf", "word2vec", or "glove")}

\item{glove_path}{Path to pre-trained GloVe file (if using "glove" method)}
}
\value{
A list containing all similarity measures and visualizations
}
\description{
This function generates a comprehensive report of all similarity measures.
}
\examples{
\donttest{
speech1 <- "This is the first speech. It talks about important topics."
speech2 <- "This is the second speech. It covers similar subjects."
report <- gen_sim_report(speech1, speech2)
}
}
