% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conversation_sequence_utilities.R
\name{combine_sim_seq}
\alias{combine_sim_seq}
\title{Combine Similarity Measures}
\usage{
combine_sim_seq(similarities, weights = NULL)
}
\arguments{
\item{similarities}{A list of similarity measures for a single dyad}

\item{weights}{A numeric vector of weights for each similarity measure (default is equal weights)}
}
\value{
A list containing the combined sequence and average similarity
}
\description{
Combine similarity measures for a single dyad
}
\details{
This function combines multiple similarity measures into a single overall similarity score for a single dyad.
}
\examples{
sim1 <- list(sequence = c(0.8, 0.7, 0.9), average = 0.8)
sim2 <- list(sequence = c(0.6, 0.8, 0.7), average = 0.7)
combine_sim_seq(list(sim1, sim2))
print(plot)
}
