% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zp2tf.R
\name{zp2tf}
\alias{zp2tf}
\title{Zero-pole-gain model conversion to Transfer function model}
\usage{
zp2tf(z, p, k)
}
\arguments{
\item{z}{A numeric vector containing zero locations}

\item{p}{A numeric vector containing pole locations}

\item{k}{A numeric vector for gain}
}
\value{
Returns a list object of 'tf' class.
}
\description{
\code{zp2tf} converts the model for a zero-pole-gain system to transfer function representation
}
\details{
\code{zp2tf} converts a model object for a zero-pole-gain system to a transfer function model

Another possible usage is: \code{zp2tf(sys)}

where \code{sys} is  an object of zero-pole-gain model.
}
\examples{
systf <- zp2tf(zpk(NULL, c(-1,-1), 1))
zp2tf(tf2zp(c(2,2,1), c(1,2,1)))

}
\seealso{
\code{\link{zp2ss}} \code{\link{tf2zp}}
}
