% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zp2ss.R
\name{zp2ss}
\alias{zp2ss}
\title{Convert Zero-Pole-Gain Model to State-Space Model}
\usage{
zp2ss(z,p,k)
}
\arguments{
\item{z}{Zero, a vector or single row matrix}

\item{p}{Pole, a vector or single row matrix}

\item{k}{Gain, a vector}
}
\value{
Returns a list object of 'ss' class.
}
\description{
\code{zp2ss} converts a system represented in zero-pole form to state-space
}
\details{
\code{zp2ss} converts a system represented in zero-pole form to state-space by converting from zero-pole to transfer function and from transfer functon to state-space

Another possible usage is: \code{zp2ss(sys)}

where \code{sys} is  an object of zero-pole-gain model.
}
\examples{
zp2ss(NULL, c(-1,-1), 1)
zp2ss(tf2zp(c(1,1,1), c(1,2,1)))

}
\seealso{
\code{\link{ss2zp}} \code{\link{zp2tf}}
}
