% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tf2zp.R
\name{tf2zp}
\alias{tf2zp}
\title{Transfer function model conversion to Zero-Pole-Gain model.}
\usage{
tf2zp(num, den)
}
\arguments{
\item{num}{A numeric vector containing the coefficients of the}

\item{den}{A numeric vector containing the coefficients of the}
}
\value{
Returns a list object of 'zpk' class.
}
\description{
\code{tf2zp} converts the model for a transfer function to zero-pole-gain representation
}
\details{
\code{tf2zp} converts a model object for a transfer function to a zero-pole model, Where \code{num} is the numerator and \code{den} is the denominator
of the transfer function and \code{sys} is a transfer function object

Another possible call is: \code{tf2zp(sys)}

where \code{sys} is  an object of transfer-function model.
}
\examples{
syszp1 <- tf2zp(c(1,1), c(1,2,1))
syszp1
syszp2 <- tf2zp(c(2,2,1), c(1,2,1))
syszp2
unclass(syszp2) # to see list of the zeros,poles and gain as vectors
tf2zp(zp2tf(c(-1,-1), c(-1,-2), 5))
}
\seealso{
\code{\link{tf2ss}} \code{\link{zp2tf}}
}
