% Generated by roxygen2 (4.1.1): do not edit by hand
% Please edit documentation in R/delaunayMesh.R
\name{getDelaunayMesh}
\alias{getDelaunayMesh}
\title{Get Delaunay Mesh}
\usage{
getDelaunayMesh(x, y)
}
\arguments{
\item{x}{numeric vector of x values}

\item{y}{numeric vector of y values of same length as x}
}
\value{
\code{matrix} object having three columns that represent the (1-based) indexes of each vertex
relative to the data in the \code{x} and \code{y} input parameters.
}
\description{
Retrieves the Delaunay Mesh for a series of x and y points in 2D.
With the exception of a few brief checks, is almost a direct wrapper to the \code{\link[geometry]{delaunayn}}
function as part of the geometry package.
}
\examples{
#Generate a sample Delaunay Mesh
set.seed(1)
x  = runif(100)
y  = runif(100)
dm = getDelaunayMesh(x,y)

#To demonstrate, Lets view the mesh
library(ggplot2)
library(reshape)
df = as.data.frame(dm); df$id = 1:nrow(df); df = melt(df,id="id")
df = cbind(df,data.frame(x,y)[df$value,])
ggplot(data=df,aes(x,y,group=id)) +
 geom_polygon(aes(fill=id),color="gray")
}

