% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data_documentation.R
\docType{data}
\name{data_fernando}
\alias{data_fernando}
\title{Data from Fernando et al.}
\format{
An object of class \code{data.frame} with 9 rows and 2 columns.
}
\source{
Fernando et al. (1983).
Identifying All Connected Subsets In A Two-Way Classification Without Interaction.
J. of Dairy Science, 66, 1399-1402. Table 1.
https://doi.org/10.3168/jds.S0022-0302(83)81951-1
}
\usage{
data_fernando
}
\description{
Data from Fernando et al.
}
\details{
A dataframe with 2 treatment factors.
The treatment combinations form 2 disconnected groups.
}
\examples{
library(lfe)
cbind(data_fernando,
      .group=con_check(data_fernando, ~ gen + herd))
library(connected)
set.seed(42)
data_fernando = transform(data_fernando,
  y=stats::rnorm(9, mean=100))
con_view(data_fernando, y ~ gen*herd, cluster=FALSE,
  main = "Fernando unsorted")
con_view(data_fernando, y ~ gen*herd, main="Fernando clustered")

}
\keyword{datasets}
