% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/get.R
\name{get_users}
\alias{get_users}
\title{Get user information from the Posit Connect server}
\usage{
get_users(
  src,
  page_size = 500,
  prefix = NULL,
  limit = Inf,
  user_role = NULL,
  account_status = NULL
)
}
\arguments{
\item{src}{The source object}

\item{page_size}{the number of records to return per page (max 500)}

\item{prefix}{Filters users by prefix (username, first name, or last name).
The filter is case insensitive.}

\item{limit}{The max number of records to return}

\item{user_role}{Optionally filter by user role ("administrator",
"publisher", "viewer"). Pass in a vector of multiple roles to match any value
(boolean OR). When \code{NULL} (the default), results are not filtered.}

\item{account_status}{Optionally filter by account status ("locked",
"licensed", "inactive"). Pass a vector of multiple statuses to match any
value (boolean OR). When \code{NULL} (the default), results are not filtered.}
}
\value{
A tibble with the following columns:
\itemize{
\item \code{email}: The user's email
\item \code{username}: The user's username
\item \code{first_name}: The user's first name
\item \code{last_name}: The user's last name
\item \code{user_role}: The user's role. It may have a value of administrator,
publisher or viewer.
\item \code{created_time}: The timestamp (in RFC3339 format) when the user was
created in the Posit Connect server
\item \code{updated_time}: The timestamp (in RFC3339 format) when the user was last
updated in the Posit Connect server
\item \code{active_time}: The timestamp (in RFC3339 format) when the user was last
active on the Posit Connect server
\item \code{confirmed}: When false, the created user must confirm their account
through an email. This feature is unique to password authentication.
\item \code{locked}: Whether or not the user is locked
\item \code{guid}: The user's GUID, or unique identifier, in UUID RFC4122 format
}
}
\description{
Get user information from the Posit Connect server
}
\details{
Please see https://docs.posit.co/connect/api/#get-/v1/users for more information.
}
\examples{
\dontrun{
library(connectapi)
client <- connect()

# Get all users
get_users(client)

# Get all licensed users
get_users(client, account_status = "licensed")

# Get all users who are administrators or publishers
get_users(client, user_role = c("administrator", "publisher"))
}

}
