% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ci_measures_of_location.R
\name{ci_median}
\alias{ci_median}
\title{CI for the Population Median}
\usage{
ci_median(
  x,
  probs = c(0.025, 0.975),
  type = c("binomial", "bootstrap"),
  boot_type = c("bca", "perc", "norm", "basic"),
  R = 9999L,
  seed = NULL,
  ...
)
}
\arguments{
\item{x}{A numeric vector.}

\item{probs}{Lower and upper probabilities, by default \code{c(0.025, 0.975)}.}

\item{type}{Type of CI. One of "binomial" (default), or "bootstrap".}

\item{boot_type}{Type of bootstrap CI. Only used for \code{type = "bootstrap"}.}

\item{R}{The number of bootstrap resamples. Only used for \code{type = "bootstrap"}.}

\item{seed}{An integer random seed. Only used for \code{type = "bootstrap"}.}

\item{...}{Further arguments passed to \code{\link[boot:boot]{boot::boot()}}.}
}
\value{
An object of class "cint", see \code{\link[=ci_mean]{ci_mean()}} for details.
}
\description{
This function calculates CIs for the population median by calling \code{\link[=ci_quantile]{ci_quantile()}}.
}
\examples{
ci_median(1:100)
}
\seealso{
\code{\link[=ci_quantile]{ci_quantile()}}
}
