% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utility.R
\encoding{UTF-8}
\name{adjust_Rsq}
\alias{adjust_Rsq}
\title{Adjust a regression model R-squared for overfitting}
\usage{
adjust_Rsq(Rsq, n, p, adjust = c("fisher", "pop", "cv"))
}
\arguments{
\item{Rsq}{Observed model R-squared}

\item{n}{Sample size}

\item{p}{Number of predictors}

\item{adjust}{Which adjustment to apply. Options are "fisher" for the Adjusted R-squared method used in \code{\link[stats:lm]{stats::lm()}}, "pop" for the positive-part Pratt estimator of the population R-squared, and "cv" for the Browne/positive-part Pratt estimator of the cross-validity R-squared. Based on Shieh (2008), these are the estimators for the population and cross-validity R-squared values that show the least bias with a minimal increase in computational complexity.}
}
\value{
An adjusted R-squared value.
}
\description{
Estimate shrinkage for regression models
}
\examples{
adjust_Rsq(.55, 100, 6, adjust = "pop")
}
\references{
Shieh, G. (2008).
Improved shrinkage estimation of squared multiple correlation coefficient and squared cross-validity coefficient.
\emph{Organizational Research Methods, 11}(2), 387–407. \doi{10.1177/1094428106292901}
}
