% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/condpath.R
\name{tours}
\alias{tours}
\alias{randomPath}
\alias{seqPath}
\alias{alongPath}
\title{Constructs a various tours of data space}
\usage{
randomPath(data, length = 10, reorder = TRUE, conditionvars = NULL, ...)

seqPath(data, length = 10, reorder = FALSE, conditionvars = NULL, ...)

alongPath(data, var, length = 10, current = NULL, ...)
}
\arguments{
\item{data}{A dataframe}

\item{length}{Path length, defaults to 10}

\item{reorder}{If TRUE (default) uses DendSer to reorder the path \code{\link[DendSer]{dser}}}

\item{conditionvars}{A vector of variable names. The returned tour is for this subset of variables.}

\item{...}{ignored}

\item{var}{A variable name for alongPath}

\item{current}{Default value of variables for alongPath}
}
\value{
A dataframe with the path
}
\description{
Constructs a various tours of data space
}
\section{Functions}{
\itemize{
\item \code{randomPath()}: Constructs a tour of data space following random observations

\item \code{seqPath()}: Constructs a tour of data space following first length observations

\item \code{alongPath()}: Constructs a tour of data space  of length equi-spaced values in the range of var.
If var is a factor, its levels are used.

}}
\examples{
randomPath(mtcars,length=5)
seqPath(mtcars,length=5)
alongPath(mtcars,var="mpg", length=5, current=mtcars[1,])
}
