% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fitpath.R
\name{fitPath}
\alias{fitPath}
\alias{lofPath}
\alias{diffitsPath}
\alias{hiresponsePath}
\alias{loresponsePath}
\title{Constructs tours of data space based on fits.}
\usage{
lofPath(
  data,
  fits,
  length = 10,
  reorder = TRUE,
  conditionvars = NULL,
  predictArgs = NULL,
  response = NULL,
  ...
)

diffitsPath(
  data,
  fits,
  length = 10,
  reorder = TRUE,
  conditionvars = NULL,
  predictArgs = NULL,
  ...
)

hiresponsePath(
  data,
  response = NULL,
  length = 10,
  reorder = TRUE,
  conditionvars = NULL,
  ...
)

loresponsePath(
  data,
  response = NULL,
  length = 10,
  reorder = TRUE,
  conditionvars = NULL,
  ...
)
}
\arguments{
\item{data}{A dataframe}

\item{fits}{A model fit or list of fits}

\item{length}{Path length, defaults to 10}

\item{reorder}{If TRUE (default) uses DendSer to reorder the path \code{\link[DendSer]{dser}}}

\item{conditionvars}{A vector of variable names. The returned tour is for this subset of variables.}

\item{predictArgs}{Extra inputs to CVpredict}

\item{response}{The name of the response variable}

\item{...}{ignored}
}
\value{
A dataframe with the path
}
\description{
Constructs tours of data space based on fits.
}
\section{Functions}{
\itemize{
\item \code{lofPath()}: Constructs a tour of data space showing biggest absolute residuals from fits.

\item \code{diffitsPath()}: Constructs a tour of data space showing biggest differences in fits.

\item \code{hiresponsePath()}: Constructs a tour of data space showing high  (numeric) response values

\item \code{loresponsePath()}: Constructs a tour of data space showing low  (numeric) response values

}}
\examples{
fit1 <- lm(mpg ~ wt+hp+am, data=mtcars)
fit2 <- lm(mpg ~ wt, data=mtcars)
lofPath(mtcars,fit1, response="mpg")
diffitsPath(mtcars,list(fit1,fit2))
}
