% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/remove_env.R
\name{remove_env}
\alias{remove_env}
\title{Remove a Conda Environment}
\usage{
remove_env(env_name = "condathis-env", verbose = "silent")
}
\arguments{
\item{env_name}{Character. Name of the Conda environment where the packages
are going to be installed. Defaults to 'condathis-env'.}

\item{verbose}{Character string specifying the verbosity level of the function's output. Acceptable values are:
\itemize{
\item \strong{"silent"}: Suppress all output from internal command-line tools. Equivalent to \code{FALSE}.
\item \strong{"cmd"}: Print the internal command(s) passed to the command-line tool.
\item \strong{"output"}: Print the standard output and error from the command-line tool to the screen. Note that the order of the standard output and error lines may not be correct, as standard output is typically buffered. If the standard output and/or error is redirected to a file or they are ignored, they will not be echoed.
\item \strong{"full"}: Print both the internal command(s) (\code{"cmd"}) and their standard output and error (\code{"output"}). Equivalent to \code{TRUE}.
Logical values \code{FALSE} and \code{TRUE} are also accepted for backward compatibility but are \emph{soft-deprecated}. Please use \code{"silent"} and \code{"full"} respectively instead.
}}
}
\value{
An object of class \code{list} representing the result of the command
execution. Contains information about the standard output, standard error,
and exit status of the command.
}
\description{
Remove a Conda environment previously created by \code{create_env()}.
}
\examples{
\dontrun{
condathis::with_sandbox_dir({
  condathis::create_env(
    packages = "fastqc",
    env_name = "fastqc-env"
  )
  condathis::remove_env(env_name = "fastqc-env")
})
}

}
