% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ternStab.R
\name{ternStab}
\alias{ternStab}
\title{Plotting the relative contribution of stabilizing effects}
\usage{
ternStab(x, ..., point = TRUE, add = FALSE)
}
\arguments{
\item{x}{object of class \code{'comstab'}.}

\item{...}{other parameters to be passed through to plotting functions.}

\item{point}{plot the community on the ternary plot (\code{logical}, defaults to TRUE)}

\item{add}{add the community on the current plot window (\code{logical}, defaults to FALSE)}
}
\value{
No return value, graphical function.
}
\description{
\code{ternStab()} is a graph function used to represent the relative contributions
of the three stabilizing effects ("Dominance", "Asynchrony" and "Averaging") on a
ternary plot.
}
\examples{
require(Ternary)

# Simulates a custom community time series using 'comTS()':
z <- comTS(nsp = 10, ny = 30, even = 0.6, mvs = 1.5, sync = "0")

# Runs the partitioning of the community coefficient of variation:
x <- partitionR(z)

# Plots the relative contributions
oldpar <- par(no.readonly = TRUE)
par(mar = c(0, 0, 0, 0))
ternStab(x)

# Adds a second community on the ternary plot
z2 <- comTS(nsp = 15, ny = 30, even = .7, mvs = 1.1, sync = "1")
x2 <- partitionR(z2)
ternStab(x2, add = TRUE, col = "red")

par(oldpar)

}
\author{
Jules Segrestin, \email{jsegrestin@gmail.com}
}
