% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/zlm.wfit.R
\name{plot.zlm}
\alias{plot.zlm}
\title{Plot Diagnostics for a Complex Linear Model Objects}
\usage{
\method{plot}{zlm}(
  x,
  which = c(1, 3, 5),
  caption = list("Residuals vs Fitted", "Scale-Location", "Cook's distance",
    "Residuals vs Leverage", expression("Cook's dist vs Leverage  " * h[ii]/(1 - h[ii]))),
  panel = if (add.smooth) function(x, y, ...) panel.smooth(x, y, iter = iter.smooth, ...)
    else points,
  sub.caption = NULL,
  main = "",
  ask = prod(par("mfcol")) < length(which) && dev.interactive(),
  ...,
  id.n = 3,
  labels.id = names(residuals(x)),
  cex.id = 0.75,
  cook.levels = c(0.5, 1),
  add.smooth = getOption("add.smooth"),
  iter.smooth = if (isGlm) 0 else 3,
  label.pos = c(4, 2),
  cex.caption = 1,
  cex.oma.main = 1.25
)
}
\arguments{
\item{x}{complex lm object ("zlm" or "rzlm"). Typically produced by \link{lm} or \link{rlm}.}

\item{which}{If a subset of the plots is required, specify a subset of the numbers 1:6, except 2. See \link[stats:plot.lm]{stats::plot.lm}, and below, for the different kinds. Default is c(1,3,5).}

\item{caption}{captions to appear above the plots;
    \code{\link{character}} vector or \code{\link{list}} of valid
    graphics annotations, see \code{\link{as.graphicsAnnot}}, of length
    6, the j-th entry corresponding to \code{which[j]}, see also the
    default vector in \sQuote{Usage}.  Can be set to
    \code{""} or \code{NA} to suppress all captions.
  }

\item{panel}{panel function.  The useful alternative to
    \code{\link{points}}, \code{\link{panel.smooth}} can be chosen
    by \code{add.smooth = TRUE}.}

\item{sub.caption}{common title---above the figures if there are more
    than one; used as \code{sub} (s.\code{\link{title}}) otherwise.  If
    \code{NULL}, as by default, a possible abbreviated version of
    \code{deparse(x$call)} is used.}

\item{main}{title to each plot---in addition to \code{caption}.}

\item{ask}{logical; if \code{TRUE}, the user is \emph{ask}ed before
    each plot, see \code{\link{par}(ask=.)}.}

\item{...}{other parameters to be passed through to plotting
    functions.}

\item{id.n}{number of points to be labelled in each plot, starting
    with the most extreme.}

\item{labels.id}{vector of labels, from which the labels for extreme
    points will be chosen.  \code{NULL} uses observation numbers.}

\item{cex.id}{magnification of point labels.}

\item{cook.levels}{levels of Cook's distance at which to draw contours.}

\item{add.smooth}{logical indicating if a smoother should be added to
    most plots; see also \code{panel} above.}

\item{iter.smooth}{the number of robustness iterations, the argument
    \code{iter} in \code{\link{panel.smooth}()}; the default uses no such
    iterations for \code{\link[stats]{glm}} fits which is
    particularly desirable for the (predominant) case of binary
    observations, but also for other models where the response
    distribution can be highly skewed.}

\item{label.pos}{positioning of labels, for the left half and right
    half of the graph respectively, for plots 1-3, 5, 6.}

\item{cex.caption}{controls the size of \code{caption}.}

\item{cex.oma.main}{controls the size of the \code{sub.caption} only if
    that is \emph{above} the figures when there is more than one.}
}
\value{
Several diagnostic plots.
}
\description{
A modified version of \link[stats:plot.lm]{stats::plot.lm} used for visualizing ordinary ("zlm") and robust ("rzlm")
linear models of complex variables. This documentation entry describes the complex version, focusing on the
differences and changes from the numeric. For further explanation of the plots please see \link[stats:plot.lm]{stats::plot.lm}.
}
\details{
Five of the six plots generated by \link[stats:plot.lm]{stats::plot.lm} can be produced by this function:
The residuals vs. fitted values plot, the scale-location plot, the plot of Cook's distances vs. row labels,
the plot of residuals vs. leverages, and the plot of Cook's distances vs. leverage/(1-leverage). The Q-Q plot is
\emph{not} drawn because it requires quantiles, which are not unambiguously defined for complex numbers.
Because complex numbers are two dimensional, \link{pairs} is used to create multiple scatter plots of the real
and imaginary components for the residuals vs. fitted values and scale-location plots.
}
\examples{
set.seed(4242)
n <- 8
slop <- complex(real = 4.23, imaginary = 2.323)
interc <- complex(real = 1.4, imaginary = 1.804)
e <- complex(real=rnorm(n)/6, imaginary=rnorm(n)/6)
xx <- complex(real= rnorm(n), imaginary= rnorm(n))
tframe <- data.frame(x = xx, y= slop*xx + interc + e)
fit <- lm(y ~ x, data = tframe, weights = rep(1,n))
plot(fit)
}
\references{
Belsley, D. A., Kuh, E. and Welsch, R. E. (1980). Regression Diagnostics. New York: Wiley.

Cook, R. D. and Weisberg, S. (1982). Residuals and Influence in Regression. London: Chapman and Hall.

Firth, D. (1991) Generalized Linear Models. In Hinkley, D. V. and Reid, N. and Snell, E. J., eds: Pp. 55-82 in Statistical Theory and Modelling. In Honour of Sir David Cox, FRS. London: Chapman and Hall.

Hinkley, D. V. (1975). On power transformations to symmetry. Biometrika, 62, 101-111. doi: 10.2307/2334491.

McCullagh, P. and Nelder, J. A. (1989). Generalized Linear Models. London: Chapman and Hall.
}
\seealso{
\link{zhatvalues}, \link{cooks.distance}, \link{lm}, \link{rlm}
}
