% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/avg_degree_bnr.R
\name{avg_degree_bnr}
\alias{avg_degree_bnr}
\alias{avg_degree_bnr,numeric,numeric,numeric,numeric-method}
\title{Expected average degree of BNR networks}
\usage{
avg_degree_bnr(n, pb, pn, pr)

\S4method{avg_degree_bnr}{numeric,numeric,numeric,numeric}(n, pb, pn, pr)
}
\arguments{
\item{n}{Number of nodes in the network}

\item{pb}{Probability to connect to parent (default is 1)}

\item{pn}{Probability to connect to neighbour of parent(s)}

\item{pr}{Probability to connect to individuals that are not connected to}
}
\value{
Returns the expected average degree of a BNR network as a numeric value. This value is an analytic result and not a numeric approximation (compare examples below).
}
\description{
Calculates the expected average degree of a BNR network (single parent only) based on the approximation by Ilany and Akcay, 2016 (see details).
}
\details{
The expected average degree \eqn{\bar{d}} is calculated as \deqn{ \bar{d} = \frac{(N-1)(p_b + (N-2)p_r)}{N-1-(N-2)(p_n - p_r)} }
}
\examples{
# Expected degree
avg_degree_bnr(n = 100, pb = 1, pn = .2, pr = .02)
# Compare to simulated network with identical parameters
adjm <- make_bnr(n = 100, np = c(0,0), pb = 1, pn = .2, pr = .02)
mean(adjm) * 100
}
\references{
Ilany, A., and Akçay, E. (2016). Personality and Social Networks: A Generative Model Approach. Integrative and Comparative Biology, 56(6), 1197–1205. \doi{10.1093/icb/icw068}
}
