% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calscco.R
\name{calscco}
\alias{calscco}
\title{Calculate Cartesian coordinates of side chains}
\usage{
calscco(pdb, resno, chi)
}
\arguments{
\item{pdb}{A PDB object}

\item{resno}{The residue number of the amino acid side chain to rotate}

\item{chi}{A vector of dihedral angles (in degrees), with length matching the number of free side chain dihedral angles for that amino acid type.  See \link{atomdeps} for definitions.}
}
\value{
Returns a PDB object with updated coordinates of side chain atoms in "resno".
}
\description{
Rotates the free side chain dihedral angles of an amino acid to the specified values. Calculates the updated Cartesian coordinates of all the atoms of that amino acid side chain.
}
\details{
Calls \link{calCo} successively for each atom in the amino acid side chain, using the bond parameters defined in \link{atomdeps}.
}
\examples{
## Position 10 of nat879 is ASP with 2 side chain dihedrals chi1 and chi2
nat879$atom[nat879$atom$resno==10,]
pdbn <- calscco(nat879,10,c(60.0,-80.0))
pdbn$atom[pdbn$atom$resno==10,]

}
