% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcLR.R
\name{calcLR}
\alias{calcLR}
\title{Calculate the likelihood ratio}
\usage{
calcLR(control, recovered, background, method = c("mvn", "kde", "lindley"))
}
\arguments{
\item{control}{a \code{compitem} object with the control item information.}

\item{recovered}{a \code{compitem} object with the recovered item information.}

\item{background}{a \code{compcovar} object with the population information.}

\item{method}{a choice of the method used to calculate the LR. Presently there
are three methods, \code{"mvn"} - multivariate normal approximation, \code{"kde"} - (multivariate) kernel
density estimates and \code{"lindely"} which uses the method published by Lindley (1977).}
}
\value{
an estimate of the likelihood ratio
}
\description{
Takes a \code{compitem} object which represents some control item, and a
\code{compitem} object which represents a recovered item, then uses information
from a \code{compcovar} object, which represents the information from the
population, to calculate a likelihood ratio (LR) as a measure of the evidence
given by the observations for the same/different source propositions.
}
\examples{
data(glass)

controlMeasurements = subset(glass, item == "s1")
control = makeCompItem(item ~ logKO + logCaO + logFeO, 
                       data = controlMeasurements[1:6,])
recovered.1 = makeCompItem(item ~ logKO + logCaO + logFeO, 
                       data = controlMeasurements[7:12,])
recoveredMeasurements = subset(glass, item == "s2")
recovered.2 = makeCompItem(item ~ logKO + logCaO + logFeO,
                           data = recoveredMeasurements[7:12,])
                           
background = makeCompVar(item ~ logKO + logCaO + logFeO, data = glass)
                           
## Same source comparison using a multivariate normal (MVN) approximation
calcLR(control, recovered.1, background)

## Same source comparison using a multivariate kernel density estimate (MVK) approximation
calcLR(control, recovered.1, background, "kde")

## Different source comparison using a multivariate normal (MVN) approximation
calcLR(control, recovered.2, background)

## Different source comparison using a multivariate kernel density estimate (MVK) approximation
calcLR(control, recovered.2, background, "kde")

}
\references{
Aitken, C.G.G. & Lucy, D. (2004) Evaluation of trace evidence in the form of multivariate data. \emph{Applied Statistics}: \bold{53}(1); 109-122.
}
