
<!-- README.md is generated from README.Rmd. Please edit that file -->

# compareCstat

<!-- badges: start -->
<!-- badges: end -->

compareCstat is an R package that compares the C-statistics (concordance
statistics) between two fitted survival models (e.g., Cox models) using
bootstrap resampling. It returns bootstrapped confidence intervals and a
p-value for the difference in C-statistics — useful for model
performance comparison.

## Installation

You can install the development version of compareCstat from
[GitHub](https://github.com/) with:

``` r
# install.packages("devtools")
devtools::install_github("Lemonade0924/compareCstat")
```

## Example

This is a basic example which shows you how to solve a common problem:

``` r
library(compareCstat)
library(survival)

lung <- survival::lung
# Make sure 0 = censored, 1 = event for Uno C

lung$status <- ifelse(lung$status == 2, 1, 0)
model1 <- coxph(Surv(time, status) ~ age, data = lung)
model2 <- coxph(Surv(time, status) ~ age + sex, data = lung)

compare_c_stat(model1, model2, data = lung, R = 100, method = "Uno", tau = 1 * 365.25)
#>                Model C_Statistic CI_Lower CI_Upper P_Value
#> 1      Model 1 (Raw)      0.5486   0.5010   0.5962    <NA>
#> 2 Model 2 (Extended)      0.5991   0.5519   0.6463    <NA>
#> 3         Difference      0.0505   0.0099   0.0910   0.015
```
