% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcVTG.R
\name{calcVTG}
\alias{calcVTG}
\alias{vairtepgrad}
\alias{vtg}
\alias{vairtmpgrad}
\title{PPD with Vertical Air Temperature Gradient}
\usage{
calcVTG(ta, tr, vel, rh, clo, met, v_tmp_grad)
}
\arguments{
\item{ta}{a numeric value presenting air temperature in [degree C]}

\item{tr}{a numeric value presenting mean radiant temperature in [degree C]}

\item{vel}{a numeric value presenting air velocity in [m/s]}

\item{rh}{a numeric value presenting relative humidity [\%]}

\item{clo}{a numeric value presenting clothing insulation level in [clo]}

\item{met}{a numeric value presenting metabolic rate in [met]}

\item{v_tmp_grad}{vertical temperature gradient between the feet and the head [degree C/m]}
}
\value{
Predicted Percentage of Dissatisfied with vertical temperature gradient in [\%]

Acceptability in [boolean]
}
\description{
Function to calculate vertical air temperature gradient using the predicted percentage of dissatisfied.
}
\details{
Calculates the percentage of thermally dissatisfied persons with a vertical temperature gradient between feet and head. Applicable only for velocity(vel) < 0.2 m/s
}
\examples{
calcVTG(25,25,0.1,50,0.5,1.2,7) 
# returns Vertical Air Temperature Gradient:12.4, Acceptability:FALSE
}
\references{
Original code in Python by Tartarini & Schiavon (2020) <doi:10.1016/j.softx.2020.100578>
}
\author{
Code implemented in to R by Shoaib Sarwar. Further contribution by Marcel Schweiker.
}
