% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calcIREQ.R
\name{calcIREQ}
\alias{calcIREQ}
\alias{calcireq}
\alias{IREQ}
\alias{ireq}
\title{IREQ and Dlim}
\usage{
calcIREQ(M,W,ta,tr,p,w,v,rh,clo)
}
\arguments{
\item{M}{a numeric value presenting metabolic energy production (58 to 400 W/m2) in [W/m2]}

\item{W}{a numeric value presenting Rate of mechanical work, (normally 0) in [W/m2]}

\item{ta}{a numeric value presenting ambiant air temperature in [degree C]}

\item{tr}{a numeric value presenting mean radiant temperature in [degree C]}

\item{p}{a numeric value presenting air permeability (low < 5, medium 50, high > 100 l/m2s) in [l/m2s]}

\item{w}{a numeric value presenting walking speed (or calculated work created air movements) in [m/s]}

\item{v}{a numeric value presenting relative air velocity(0.4 to 18 m/s) in [m/s]}

\item{rh}{a numeric value presenting relative humidity [\%]}

\item{clo}{a numeric value presenting clothing insulation level in [clo]}
}
\value{
\code{calcIREQ} returns
\item{IREQminimal }{Lower bound of insulation required in [clo]}
\item{IREQneutral }{Upper bound of insulation required in [clo]}
\item{ICLminimal }{Lower bound of REQUIRED basic clothing insulation (ISO 9920) in [clo]}
\item{ICLneutral }{Upper bound of REQUIRED basic clothing insulation (ISO 9920) in [clo]}
\item{DLEminimal }{Lower bound of duration limited exposure in [hours]}
\item{DLEneutral }{upper bound of duration limited exposure in [hours]}
}
\description{
Calculate minimal and neutral values of REQUIRED CLOTHING INSULATION (IREQ) and DURATION LIMITED EXPOSURE (Dlim).
}
\details{
The function gives IREQ Insulation of clothing required to maintain thermal equilibrium of the body at specified levels of physiological stress.
}
\note{
The authors disclaim all obligations and liabilities for damages arising from the use or attempted use of the information, including, but not limited to, direct, indirect, special and consequential damages, and attorneys' and experts' fees and court costs. Any use of the information will be at the risk of the user.
}
\examples{
calcIREQ(116,0,-15,-15,8,0.3,0.4,85,2.5)
}
\references{
ISO 11079, 2007-12-15, ERGONOMICS OF THE THERMAL ENVIRONMENT - DETERMINATION AND INTERPRETATION OF COLD STRESS WHEN USING REQUIRED CLOTHING INSULATION (IREQ) AND LOCAL COOLING EFFECTS
}
\author{
Developed by Ingvar Holmer and Hakan O. Nilsson, 1990 in java and transferred to R by Shoaib Sarwar. Further contribution by Marcel Schweiker.
}
