% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/banerjee.R, R/boswijk.R, R/englegranger.R,
%   R/johansen.R
\name{banerjee}
\alias{banerjee}
\alias{boswijk}
\alias{englegranger}
\alias{johansen}
\title{Cointegration Tests}
\usage{
banerjee(formula, data, lags = 1, trend = "const")

boswijk(formula, data, lags = 1, trend = "const")

englegranger(formula, data, lags = 1, trend = "const")

johansen(formula, data, type = "eigen", lags = 1, trend = "const")
}
\arguments{
\item{formula}{An object of class \code{\link[stats]{formula}} to describe the model.}

\item{data}{An optional data frame containing the variables in the model.}

\item{lags}{Number of lags to be included.}

\item{trend}{Type of deterministic component to be inlcuded, "none" for no deterministics,
"const" for a constant and "trend" for a constant plus trend.}

\item{type}{Test to be conducted, either "eigen" or "trace".}
}
\value{
Returns an object of class \code{"list"}.
}
\description{
Executes common cointegration tests, which serve as underlying tests for the Bayer Hanck Test statistic.
}
\section{Functions}{
\itemize{
\item \code{banerjee()}: Executes Banerjee Test.

\item \code{boswijk()}: Executes Boswijk Test.

\item \code{johansen()}: Executes Johansen Test.

}}
\examples{
# Luetkepohl (2007): Economic data from West Germany
data(lutkepohl_e1)
englegranger(linvestment ~ lincome + lconsumption, data = lutkepohl_e1)

#' @examplesIf requireNamespace("MTS", quietly = TRUE)
# World Almanac and Book of Facts (1975): Monthly simple returns of the stocks of IBM,
# Coca Cola and S&P Composite index
try({
  data("mts-examples", package = "MTS")
  englegranger(sp ~ ibm + ko, data = ibmspko)
}, silent = TRUE)


}
\references{
Engle, R. and Granger, C. (1987), Co-integration and Error Correction: Representation, Estimation, and Testing, Econometrica 55(2), 251-76.

Johansen, S. (1988), Statistical analysis of cointegration vectors, Journal of Economic Dynamics and Control 12(2-3), 231-254.

Banerjee, A., Dolado, J. J. and Mestre, R. (1998), Error-correction Mechanism Tests for Cointegration in a Single-equation Framework, Journal of Times Series Analysis 19(3), 267-283.

Boswijk, H. P. (1994), Testing for an unstable root in conditional and structural error correction models, Journal of Econometrics 63(1), 37-60.
}
