% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clsave.R
\name{clsave}
\alias{clsave}
\title{Save Colorized and Juxtaposed Images}
\usage{
clsave(response, destfile = "")
}
\arguments{
\item{response}{a response object of a \code{colorize} function call.}

\item{destfile}{a character string or vector with the name where the images are saved.}
}
\value{
Besides saving, the function returns the response object invisibly.
}
\description{
\code{clsave} saves images that have been colorized using \code{colorize} or
    juxtaposed with \code{juxtapose}.
}
\examples{
\dontrun{
# Save colorized images
res <- colorize(img = "https://upload.wikimedia.org/wikipedia/commons/9/9e/Breadfruit.jpg")
clsave(res, destfile = "colorized_version.jpg")
}
}
