% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{bcancer}
\alias{bcancer}
\title{Prognosis for women with breast cancer}
\format{
A data frame with 45 rows and 3 variables:
\describe{
\item{\code{stain}}{integer for negative staining (=1) or
positive staining (=2)}
\item{\code{time}}{integer time in
months for survival}
\item{\code{status}}{integer for status at
end of follow-up (0=censored, 1=death)}
}
}
\usage{
bcancer
}
\description{
For female breast cancer patients from Middlesex
Hospital. The dataset includes the result of staining using Helix pomatia agglutinin (HPA).
}
\details{
For details about the study design, see Leathem and Brooks (1987).

The dataset is described in Example 1.2 and Table 1.2 (Collett, 2023, pages 6-7).
}
\examples{
library(survival)
plot(survfit(Surv(time,status)~stain, data=bcancer), col=1:2, xlab="Survival time (months)",
ylab="Survival")
legend("topright", legend=c("Negative staining","Positive staining"), col=1:2, lty=1,
bty="n")
}
\references{
Leathem AJ, Brooks S. Predictive value of lectin binding on breast-cancer recurrence and survival. The Lancet. 1987 May 9;329(8541):1054-6. \doi{10.1016/S0140-6736(87)90482-X}
}
\keyword{datasets}
