% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cointReg-D-OLS.R
\name{getModD}
\alias{getModD}
\title{Get D OLS model.}
\usage{
getModD(x, y, deter, n.lag, n.lead, check = FALSE)
}
\arguments{
\item{x}{[\code{matrix}]\cr
RHS variables of the D OLS estimation.}

\item{y}{[\code{matrix}]\cr
LHS variable(s) of the D OLS estimation.}

\item{deter}{[\code{matrix}]\cr
Matrix of deterministic variables to include in the D OLS model.}

\item{n.lag, n.lead}{[\code{numeric(1)}]\cr
Number of lags and leads, have to be non-negative integer values.}

\item{check}{[\code{logical}]\cr
Wheather to check (and if necessary convert) the arguments.
See \code{\link{checkVars}} for further information.}
}
\value{
[\code{lm}]. An \code{\link{lm}} object, containing an additional
  list element (\code{aux}) with D-OLS specific objects:
\describe{
  \item{\code{Z} [\code{matrix}]}{
    jointed matrix of deterministics and x}

  \item{\code{x.delta} [\code{matrix}]}{
    differences of x}

  \item{\code{dx.all} [\code{matrix}]}{
    leads-and-lags matrix}

  \item{\code{all.trunc} [\code{matrix}]}{
    truncated version of jointed matrix of \code{Z} and \code{dx.all}}

  \item{\code{y.trunc} [\code{matrix}]}{
    truncated version of \code{y}}

}
}
\description{
Generates an \code{lm} model for the Dynamic OLS estimator.
}
\examples{
set.seed(1909)
y <- matrix(cumsum(rnorm(100)), ncol = 1)
x <- matrix(rep(y, 4) + rnorm(400, mean = 3, sd = 2), ncol = 4)
deter <- cbind(1, 1:100)
cointReg:::getModD(x = x, y = y, deter = deter, n.lag = 2, n.lead = 3)
}
\seealso{
Other D-OLS: \code{\link{cointRegD}},
  \code{\link{getLeadLag}}, \code{\link{makeLeadLagMatrix}}
}

