% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cohort_methods.R
\name{code}
\alias{code}
\title{Return reproducible data filtering code.}
\usage{
code(
  x,
  include_source = TRUE,
  include_methods = c(".pre_filtering", ".post_filtering", ".run_binding"),
  include_action = c("pre_filtering", "post_filtering", "run_binding"),
  modifier = .repro_code_tweak,
  mark_step = TRUE,
  ...
)
}
\arguments{
\item{x}{Cohort object.}

\item{include_source}{If `TRUE` source generating code will be included.}

\item{include_methods}{Which methods definition should be included in the result.}

\item{include_action}{Which action should be returned in the result.
`pre_filtering`/`.post_filtering` - to include data transformation before/after filtering.
s`run_binding` - data binding transformation.}

\item{modifier}{A function taking data frame (storing reproducible code metadata) as
an argument, and returning data frame with `expr` column which is then
combined into a single expression (final result of `get_code`).
See \link{.repro_code_tweak}.}

\item{mark_step}{Include information which filtering step is performed.}

\item{...}{Other parameters passed to \link[formatR]{tidy_source}.}
}
\value{
\link[formatR]{tidy_source} output storing reproducible code for generating final step data.
}
\description{
Return reproducible data filtering code.
}
\seealso{
\link{cohort-methods}
}
