% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cogmapr-quotes.R
\name{QuotesCMap}
\alias{QuotesCMap}
\title{Extract all quotes of a QDA project}
\usage{
QuotesCMap(project)
}
\arguments{
\item{project}{A QDA project, a list as generated by the ProjectCMap function.}
}
\value{
A data frame with relationships and quotes
}
\description{
Extract all quotes of a QDA project
}
\details{
This function creates a data frame with all quotes of a Qualitative Data Analysis (QDA) project
}
\examples{
project_name <- "a_new_project"
main_path <- paste0(system.file("testdata", package = "cogmapr"), '/')
my.project <- ProjectCMap(main_path, project_name)

QuotesCMap(my.project)
}
