% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/manual_for_datasets.R
\docType{data}
\name{charlson}
\alias{charlson}
\title{Classcodes for Charlson comorbidity based on ICD-codes}
\format{
A data frame with 17 rows and 8 variables:
\itemize{
\item \verb{group:} comorbidity groups
\item \verb{description:} Verbal description of codes as described by
Deyo et al. (1992).
\item \verb{icd10:} regular expressions identifying ICD-10 codes of each
group as decoded from Quan et al. 2005. Note that this classification was
not originally used with all weights! To simply use this classification
table with weights other than \code{quan_original} and \code{quan_updated}
might therefore lead to different results than originally intended for each
index.
\item \verb{icd9cm_deyo:}Codes from table 1 column "Deyo's ICD-9-CM"
in Quan et al. (2005).
Procedure code 38.48 for peripheral vascular disease ignored.
\item \verb{icd9cm_enhanced:} Codes from table 1 column "Enhanced ICD-9-CM"
in Quan et al. (2005).
\item \verb{icd10_rcs:} Codification by Armitage (2010).
Note that Peptic ulcer disease is not included.
All liver diseases (including mild) are included in
"moderate or severe liver disease".
All diabetes is included in "diabetes complication"
\item \verb{icd8_brusselaers:} Back translated version from ICD-10 to
ICD-8 by Brusselaers et al. (2017).
"Moderate and severe liver disease" contains all liver disease and
"diabetes complication" contains all diabetes.
\item \verb{icd9_brusselaers:} Back translated version from ICD-10 to
ICD-9 by Brusselaers et al. (2017).
"Moderate and severe liver disease" contains all liver disease and
"diabetes complication" contains all diabetes.
\item \verb{charlson:} original weights as suggested by Charlson et al.
(1987)*
\item \verb{deyo_ramano:} weights suggested by Deyo and Romano*
\item \verb{dhoore:} weights suggested by D'Hoore*
\item \verb{ghali:} weights suggested by Ghali*
\item \verb{quan_original:} weights suggested by Quan (2005)
\item \verb{quan_updated:} weights suggested by Quan (2011)
}
\itemize{
\item Weights decoded from Yurkovich et al. (2015).
}
}
\usage{
charlson
}
\description{
Classcodes for Charlson comorbidity based on ICD-codes
}
\references{
Armitage, J. N., & van der Meulen, J. H. (2010).
Identifying co-morbidity in surgical patients using administrative data
with the Royal College of Surgeons Charlson Score.
British Journal of Surgery, 97(5), 772–781.

Brusselaers N, Lagergren J. (2017)
The Charlson Comorbidity Index in Registry-based Research.
Methods Inf Med 2017;56:401–6.

Deyo, R. A., Cherkin, D. C., & Ciol, M. A. (1992).
Adapting a clinical comorbidity index for use with ICD-9-CM
administrative databases.
Journal of Clinical Epidemiology, 45(6), 613–619.

Quan Hude et al. (2005). Coding algorithms for defining
comorbidities in ICD-9-CM and ICD-10 administrative data.
Medical care, 1130-1139.

Yurkovich, M., Avina-Zubieta, J. A., Thomas, J., Gorenchtein, M., & Lacaille,
D. (2015). A systematic review identifies valid comorbidity indices derived
from administrative health data.
Journal of clinical epidemiology, 68(1), 3-14.
}
\seealso{
Other default classcodes: 
\code{\link{ae}},
\code{\link{cps}},
\code{\link{elixhauser}},
\code{\link{hip_ae_hailer}},
\code{\link{rxriskv}}
}
\concept{default classcodes}
\keyword{datasets}
