% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/parameter_variation.R
\name{par_variation}
\alias{par_variation}
\title{Variable Parameters}
\usage{
par_variation(par, variance)
}
\arguments{
\item{par}{A parameter whichs value will be made variable between the loci.}

\item{variance}{The variance of the gamma distribution, which the values used
for simulation will follow.}
}
\description{
This function can be used to let the values of a parameter vary between
the different loci. When used, the values for the enclosed parameter
will follow a gamma distribution with mean of the parameters original
value, and the variance specified as argument \code{variance}. This requires
that the original value is positive. When using this, the simulators
are called separately for each locus, which can dramatically increase the
time needed to simulate models with many loci.
}
\examples{
model <- coal_model(5, 10) +
  feat_mutation(par_variation(par_const(5), 10)) +
  sumstat_nucleotide_div()
simulate(model)
}
\seealso{
For parameters that are identical for all loci: \code{\link{parameter}}
}
