% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/r_nx.R
\name{AUC_ln_K}
\alias{AUC_ln_K}
\title{Area under the \code{RN_X} curve}
\usage{
AUC_ln_K(R_NX)
}
\arguments{
\item{R_NX}{The R_NX curve, a vector of values}
}
\value{
A value, the area under the curve.
}
\description{
Area under the \eqn{R_{NX}(K)} curve when \eqn{K} is put on a logarithmic scale.
}
\details{
It is calculated as:
\deqn{ AUC_{\ln K}(R_{NX}(K)) = \left(\sum_{K=1}^{N-2}R_{NX}(K)/K\right)/\left(\sum_{K=1}^{N-2}1/K\right) }
}
\references{
Lee, J. A., Peluffo-Ordóñez, D. H., & Verleysen, M., 2015. Multi-scale
  similarities in stochastic neighbour embedding: Reducing dimensionality
  while preserving both local and global structure. Neurocomputing, 169,
  246–261. https://doi.org/10.1016/j.neucom.2014.12.095
}
\author{
Guido Kraemer
}
