% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/dcnb.R
\name{dcnb}
\alias{dcnb}
\title{PMF of Conditional Negative Binomial}
\usage{
dcnb(x, D, r1, r2, lambda)
}
\arguments{
\item{x}{a nonempty vector of non-negative integer(s) <= D.}

\item{D}{a positive integer.}

\item{r1}{a positive value.}

\item{r2}{a positive value.}

\item{lambda}{a positive value.}
}
\value{
A vector providing values of Pr(X = x | X + Y = D) for each element in x.
}
\description{
Probability mass function of the conditional distribution of X given X + Y = D,
where X ~ NB(r1, p1) and Y ~ NB(r2, p2) are drawn from two negative binomials,
independent of each other,
and assuming p1/p2 = lambda.
}
\details{
Need to specify full list of arguments, as default values have not been set.
}
\examples{
dcnb(980, 2000, 120, 90, 0.994)
dcnb(0:7, 7, 2, 0.4, 0.6)

}
\seealso{
\code{\link{pcnb}, \link{qcnb}, \link{rcnb}.}
}
\author{
Xiaotian Zhu, \email{xiaotian.zhu.psualum@gmail.com}
}
