% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{dgnd}
\alias{dgnd}
\title{The Generalized Normal Distribution (GND)}
\usage{
dgnd(x, mu = 0, sigma = 1, nu = 2)
}
\arguments{
\item{x}{A numeric vector of observations.}

\item{mu}{A numeric value indicating the location parameter \eqn{\mu}.}

\item{sigma}{A numeric value indicating the scale parameter \eqn{\sigma}.}

\item{nu}{A numeric value indicating the shape parameter \eqn{\nu}.}
}
\value{
\code{dgnd} returns the density.
}
\description{
Density function for the GND with location parameter \code{mu},
scale parameter \code{sigma} and shape parameter \code{nu}.
}
\details{
If \code{mu}, \code{sigma} and \code{nu} are not specified
they assume the default values of 0, 1 and 2, respectively.
The GND distribution has density
\deqn{ f_{GND}(x|\mu,\sigma,\nu)=\frac{\nu}{2\sigma\Gamma(1\mathbin{/}\nu)}\exp\Biggr\{-\Biggr|\frac{x-\mu}{\sigma}\Biggr|^\nu\Biggr\}.}
The shape parameter \eqn{\nu} controls both the peakedness and tail weights.
If \eqn{\nu=1} the GND reduces to the Laplace distribution and if \eqn{\nu=2}
it coincides with the normal distribution. It is noticed that \eqn{1<\nu<2}
yields an intermediate distribution between the normal and the Laplace distribution.
As limit cases, for \eqn{\nu\rightarrow\infty} the distribution tends to a uniform
distribution, while for \eqn{\nu\rightarrow0} it will be impulsive.
}
\references{
Nadarajah, S. (2005). A generalized normal distribution.
\emph{Journal of Applied Statistics}, \eqn{32(7):685–694}.
}
