% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/comparison.R
\name{comparison_fft_ccf}
\alias{comparison_fft_ccf}
\title{Estimate translation alignment between a cell/region pair based on the
Cross-Correlation Theorem.}
\usage{
comparison_fft_ccf(cellHeightValues, regionHeightValues)
}
\arguments{
\item{cellHeightValues}{list/tibble column of x3p objects containing a
reference scan's cells (as returned by comparison_cellDivision)}

\item{regionHeightValues}{list/tibble column of x3p objects containing a
target scan's regions (as returned by comparison_getTargetRegions)}
}
\value{
A list of the same length as the input containing data frames of the
translation (x,y) values at which each reference cell is estimated to align
in its associated target region and the CCF value at this alignment.

a data frame containing the translation (x,y) at which the CCF was
maximized in aligning a target scan region to its associated reference scan
cell.
}
\description{
Estimate translation alignment between a cell/region pair based on the
Cross-Correlation Theorem.
}
\note{
The FFT is not defined for matrices containing missing values. The
missing values in the cell and region need to be replaced before using this
function. See the \link[cmcR]{comparison_replaceMissing} function to replace
missing values after standardization.
}
\examples{

data(fadul1.1_processed,fadul1.2_processed)

cellTibble <- fadul1.1_processed \%>\%
comparison_cellDivision(numCells = c(8,8)) \%>\%
dplyr::mutate(regionHeightValues =
             comparison_getTargetRegions(cellHeightValues = cellHeightValues,
                                         target = fadul1.2_processed)) \%>\%
dplyr::mutate(cellPropMissing =
           comparison_calcPropMissing(heightValues = cellHeightValues),
              regionPropMissing =
           comparison_calcPropMissing(heightValues = regionHeightValues)) \%>\%
dplyr::filter(cellPropMissing <= .85 & regionPropMissing <= .85) \%>\%
dplyr::mutate(cellHeightValues =
        comparison_standardizeHeights(heightValues = cellHeightValues),
             regionHeightValues =
        comparison_standardizeHeights(heightValues = regionHeightValues)) \%>\%
dplyr::mutate(cellHeightValues =
                  comparison_replaceMissing(heightValues = cellHeightValues),
             regionHeightValues =
            comparison_replaceMissing(heightValues = regionHeightValues)) \%>\%
dplyr::mutate(fft_ccf_df = comparison_fft_ccf(cellHeightValues,
                                             regionHeightValues))

cellTibble \%>\%
tidyr::unnest(cols = fft_ccf_df) \%>\%
head()

}
\seealso{
\url{https://mathworld.wolfram.com/Cross-CorrelationTheorem.html}
}
