% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_object-getters.R
\name{get_bins}
\alias{get_bins}
\title{Get Clusters}
\usage{
get_bins(cluster_data)
}
\arguments{
\item{cluster_data}{The output from the `cluster()` function.}
}
\value{
the created cluster `data.frame`.
}
\description{
GetClusters returns a `data.frame` of the generated
clusters from the `cluster()` function.
}
\examples{
cutoff <- 0.2
count_table <- read_count(example_path("amazon.full.count_table"))
distance_data <- read_dist(example_path("amazon_column.dist"),
                           count_table, cutoff, FALSE)
df_clusters <- cluster(distance_data, cutoff, method = "opticlust")
clusters <- get_bins(df_clusters)

}
