% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cluster_plot.R
\name{cluster_plot}
\alias{cluster_plot}
\title{Plot string clusters as graph.}
\usage{
cluster_plot(cluster, min_cluster_size = 2, label_size = 2.5,
  repel = T)
}
\arguments{
\item{cluster}{string clusters returned from `cluster_strings()`}

\item{min_cluster_size}{minimum size for clusters to be plotted.}

\item{label_size}{how big should the cluster name fonts be.}

\item{repel}{whether to "repel" (so cluster names won't overlap)}
}
\value{
a graph plot (using `ggraph`) of the string clusters.
}
\description{
Plot string clusters as graph.
}
\examples{
s_vec <- c("alcool","alcohol","alcoholic","brandy","brandie","cachaça")
s_clust <- cluster_strings(s_vec,method="lv",max_dist=3,algo="cc")
cluster_plot(s_clust,min_cluster_size=1)
}
