% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering.R
\name{rerun}
\alias{rerun}
\title{Rerun clustord using the results of a previous run as the starting point.}
\usage{
rerun(
  results.original,
  long.df,
  EM.control = NULL,
  verbose = FALSE,
  optim.control = NULL
)
}
\arguments{
\item{results.original}{The results of the previous run that you want to use
as a starting point. The model, number of clusters, and final parameter
values will be used, and the cluster controls such as EMcycles will be
reused unless the user specifies new values. But the row cluster and/or
column cluster memberships will NOT be reused, and nor will the dataset,
so you can change the dataset slightly and the rest of the details will
be applied to this new dataset.}

\item{long.df}{The dataset to use for this run, which may be slightly
different to the original. Please note that the only compatibility check
performed is comparing the sizes of the original and new datasets, and it
is up to the user to check that the new dataset is sufficiently similar
to the old one.}

\item{EM.control}{Options to use for this run such as EMcycles (number of EM
iterations). Note that "startEMcycles" will not be relevant as this run
will not generate random starts, it will run from the end parameters of
the other run. See \link{clustord} documentation for more info.}

\item{verbose}{(default \code{FALSE}) changes how much is reported to the
console during the algorithm's progress. See \link{clustord}
documentation for more info.}

\item{optim.control}{Options to use for this run within \code{optim()}, which
is used to estimate the parameters during each M-step. See \link{clustord}
documentation for more info.}
}
\value{
An object of class \code{clustord}. See \link{clustord} for more info.
}
\description{
This function is designed for two purposes.
(1) You tried to run clustord and the results did not converge. You can supply
this function with the previous results and the previous data object, and it
will carry on running clustord from the endpoint of the previous run, which
is quicker than starting the run again from scratch with more iterations.
}
\details{
(2) The previous result converged, but you have changed the dataset slightly,
and want to rerun from the previous endpoint to save time.

Either way, you call the function in the same way, supplying the previous
results object and a dataset, and optionally a new number of iterations
(`EM.control=list(EMcycles=XXX)`, where `XXX` is the new number of iterations.)

The output parameters of the old result will be used as the new initial
parameters.
}
\examples{
set.seed(1)
long.df <- data.frame(Y=factor(sample(1:3,5*20,replace=TRUE)),
               ROW=factor(rep(1:20,times=5)),COL=rep(1:5,each=20))
results.original <- clustord(Y ~ ROWCLUST, model="OSM", nclus.row=4,
                             long.df=long.df, EM.control=list(EMcycles=2))
results.original$EM.status$converged
# FALSE

## Since original run did not converge, rerun from that finishing point and
## allow more iterations this time
results.new <- rerun(results.original, long.df, EM.control=list(EMcycles=10))

## Alternatively, if dataset has changed slightly then rerun from the
## previous finishing point to give the new results a helping hand
long.df.new <- long.df[-c(4,25,140),]
results.new <- rerun(results.original, long.df.new)
}
