% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summary.kcurves.R
\name{summary.kcurves}
\alias{summary.kcurves}
\title{Summarizing fits of \code{kcurves} class produced by \code{ksurvcurves} and
\code{kregcurves}}
\usage{
\method{summary}{kcurves}(object, ...)
}
\arguments{
\item{object}{a kcurves object as producted by \code{ksurvcurves} and
\code{kregcurves}}

\item{\ldots}{additional arguments.}
}
\value{
\code{summary.kcurves} computes and returns a list of summary
information for a \code{kcurves} object.
\item{levels}{Levels of the factor.}
\item{cluster}{A vector containing the assignment of each factor's level to its group.}
}
\description{
Takes a  kcurves object
and produces various useful summaries from it.
}
\details{
\code{print.kcurves} tries to be smart about \code{summary.kcurves}.
}
\examples{
library(clustcurv)
library(survival)
data(veteran)

# Survival: 2 groups k-means
s2 <- ksurvcurves(time = veteran$time, status = veteran$status,
x = veteran$celltype, k = 2, algorithm = "kmeans")

summary(s2)


# Regression: 2 groups k-means
r2 <- kregcurves(y = barnacle5$DW, x = barnacle5$RC,
z = barnacle5$F, k = 2, algorithm = "kmeans")

summary(r2)



}
\author{
Nora M. Villanueva and Marta Sestelo.
}
