% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Functions.R
\name{CCRls}
\alias{CCRls}
\title{Sequential CCR}
\usage{
CCRls(Y, X, kap = 0.1, modclass = "lm", tol = 1e-06, reltol = TRUE,
  rndcov = NULL, report = NULL, ...)
}
\arguments{
\item{Y}{vector of dependent variable Y}

\item{X}{design matrix (without intercept)}

\item{kap}{maximum number of parameters to estimate in each active sequential step,
as a fraction of the less of total number of observations n or number of covariates p.
i.e. \eqn{min(n,p)}}

\item{modclass}{a string denoting the desired the class of model. See \link{c_chmod} for details.}

\item{tol}{level of tolerance for convergence; default \code{tol=1e-6}}

\item{reltol}{a logical for relative tolerance instead of level. Defaults at TRUE}

\item{rndcov}{seed for randomising assignment of covariates to partitions; default \code{NULL}}

\item{report}{number of iterations after which to report progress; default \code{NULL}}

\item{...}{additional arguments to be passed to the model}
}
\value{
\code{betas}  parameter estimates (intercept first),

\code{iter}  number of iterations,

\code{dev}  increment in the objective function value at convergence

\code{fval} objective function value at convergence
}
\description{
\code{CCRls} runs regressions with potentially more covariates than observations.
See \code{c_chmod()} for the list of models supported.
}
\examples{
set.seed(14) #Generate data
N = 1000; (bets = rep(-2:2,4)); p = length(bets); X = matrix(rnorm(N*p),N,p)
Y = cbind(1,X)\%*\%matrix(c(0.5,bets),ncol = 1)
CCRls(Y,X,kap=0.1,modclass="lm",tol=1e-6,reltol=TRUE,rndcov=NULL,report=8)
}
