% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rexpGpu.R
\name{rexpGpu}
\alias{rexpGpu}
\title{rexpGpu}
\usage{
rexpGpu(
  n,
  rate = 1,
  streams,
  Nglobal = getOption("clrng.Nglobal"),
  type = getOption("clrng.type"),
  verbose = FALSE
)
}
\arguments{
\item{n}{a number or a vector specifying the size of the output vector or matrix.}

\item{rate}{a number specifying the distribution parameter, mean equals to 1/rate.}

\item{streams}{a vclMatrix of streams.}

\item{Nglobal}{a (non-empty) integer vector specifying size of work items for use, with default value from global option 'clrng.Nglobal'.}

\item{type}{a character string specifying "double" or "float" of random numbers, with default value from global option 'clrng.type'.}

\item{verbose}{a logical value, if TRUE, print extra information, default is FALSE.}
}
\value{
a 'vclVector' or 'vclMatrix' of exponential random numbers.
}
\description{
Generate exponential random numbers parallely on a GPU.
}
\details{
\code{type} specifies the precision type of random numbers. If GPU supports "double", 'clrng.Nglobal' is "double", otherwise, `clrng.Nglobal' is "single".
}
\examples{
library('clrng')
if (detectGPUs() >= 1) {
  setContext(grep("gpu", listContexts()$device_type)[1])
  streams <- createStreamsGpu()
  as.vector(rexpGpu(7, streams=streams))

  # produce float precision random numbers
  options(clrng.type='float')
  as.matrix(rexpGpu(c(2,3), rate=0.5, streams))} else {
  message("No GPU context available")
}

}
