\name{pediatric_glasgow_coma_scale}
\alias{pediatric_glasgow_coma_scale}
\title{
Pediatric Glasgow Coma Scale (pGCS)
}
\description{
Calculates the Pediatric Glasgow Coma Scale score, used to assess the level of consciousness in children, particularly those who are pre-verbal (< 2 years). The scale evaluates three components: Eye opening, Verbal response, and Motor response.
}
\usage{
pediatric_glasgow_coma_scale(eye_response, verbal_response, motor_response)
}
\arguments{
  \item{eye_response}{
Numeric (1-4).
4: Spontaneous.
3: To speech/sound.
2: To pain.
1: None.
}
  \item{verbal_response}{
Numeric (1-5).
5: Coos, babbles (or Oriented).
4: Irritable cry (or Confused).
3: Cries to pain (or Inappropriate words).
2: Moans to pain (or Incomprehensible sounds).
1: None.
}
  \item{motor_response}{
Numeric (1-6).
6: Spontaneous movement (or Obeys commands).
5: Withdraws to touch (or Localizes pain).
4: Withdraws from pain.
3: Abnormal flexion (decorticate).
2: Abnormal extension (decerebrate).
1: None/Flaccid.
}
}
\value{
A list containing:
\item{pGCS_Score}{The calculated total score (Range 3-15).}
\item{Severity_Classification}{Interpretation of traumatic brain injury severity (Mild, Moderate, Severe).}
}
\references{
Teasdale G, Jennett B. Assessment of coma and impaired consciousness. A practical scale. Lancet. 1974;2(7872):81-84.
Simpson D, Reilly P. Pediatric Coma Scale. Lancet. 1982;2(8295):450.
}
\examples{

# Example 1: Normal Infant
# Eyes spontaneous (4), Coos/babbles (5), Spontaneous moves (6)
pediatric_glasgow_coma_scale(4, 5, 6)

# Example 2: Severe Injury
# Eyes to pain (2), Moans (2), Decerebrate (2)
pediatric_glasgow_coma_scale(2, 2, 2)
}
