\name{mdrd_gfr_equation}
\alias{mdrd_gfr_equation}
\title{
MDRD GFR Equation (IDMS-Traceable)
}
\description{
Calculates the estimated Glomerular Filtration Rate (eGFR) using the Modification of Diet in Renal Disease (MDRD) Study equation. This version uses the IDMS-traceable formula (standardized serum creatinine). Note: The MDRD equation has largely been superseded by CKD-EPI for general use but remains relevant in certain clinical contexts or historical data comparisons.
}
\usage{
mdrd_gfr_equation(creatinine, age, sex, race, creatinine_units = "mg/dL")
}
\arguments{
  \item{creatinine}{
Numeric. Serum Creatinine level.
}
  \item{age}{
Numeric. Patient age in years.
}
  \item{sex}{
String. Patient sex ("Male" or "Female").
}
  \item{race}{
String. Patient race ("black" or "other"). The equation applies a correction factor (x1.212) for African American patients.
}
  \item{creatinine_units}{
String. Units for creatinine input. Options: "mg/dL" (default) or "umol/L" (or "micromol/L").
}
}
\value{
A list containing:
\item{MDRD_GFR}{The estimated GFR in mL/min/1.73m^2.}
\item{CKD_Stage}{Staging classification based on the calculated GFR.}
}
\references{
Levey AS, Coresh J, Greene T, et al. Using standardized serum creatinine values in the modification of diet in renal disease study equation for estimating glomerular filtration rate. Ann Intern Med. 2006;145(4):247-254. doi:10.7326/0003-4819-145-4-200608150-00004
}
\examples{

# Example 1: Healthy Adult
# Cr 0.9, 40yo Male, Non-Black
# GFR = 175 * (0.9)^-1.154 * (40)^-0.203 = ~98
mdrd_gfr_equation(0.9, 40, "male", "other")

# Example 2: Chronic Kidney Disease
# Cr 2.5, 65yo Female, Black
# GFR = 175 * (2.5)^-1.154 * (65)^-0.203 * 0.742 * 1.212 = ~23
mdrd_gfr_equation(2.5, 65, "female", "black")
}
