% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/reporting-render-general.R
\name{clinDataReview-common-args-report}
\alias{clinDataReview-common-args-report}
\title{Common parameters for the clinical data reporting function}
\arguments{
\item{indexPath}{String with path to the index file,
by default 'index.Rmd' in \code{inputDir}.}

\item{configDir}{String with directory with config files,
by default a 'config' folder in \code{inputDir}.\cr
It should contain a general 'config.yml' file and dedicated
'config-[X].yml' for each chapter.
The order of each chapter is specified in the 'config' slot in the general 
general 'config.yml'.}

\item{configFile}{String with filename of the config
file of interest in YAML format.}

\item{inputDir}{String with input directory,
working directory by default.}

\item{outputDir}{String with output directory,
('report' by default).}

\item{intermediateDir}{String with intermediate directory ('interim'
by default), where
markdown files and rds file specifying Js libraries (with \code{knit_meta}) for
each sub report are stored.}

\item{extraDirs}{Character vector with extra directories required by
the report, directory with external images.
By default, the directories: 'figures', 'tables' and mentioned in the 
'patientProfilePath' parameter of the
general config file are included.
All these folders should be available in \code{inputDir}.}

\item{mdFile}{String with path of the Markdown file}

\item{logFile}{(optional) String with path to a log file,
where output (also error/messages/warnings) should be stored.
If specified, the entire output is re-directed to this file.}

\item{nCores}{Integer containing the number of cores used to render the report
(1 by default). If more than 1, two steps of the report creation are 
run in parallel across chapters: 
\itemize{
\item the rendering of the Rmarkdown file to Markdown
\item the conversion from Markdown to HTML
}}

\item{verbose}{Logical, if TRUE (FALSE by default) progress messages are printed
during the report execution.}
}
\value{
No return value, used for the documentation of 
the clinical data reporting functions of the package.
}
\description{
Common parameters for the clinical data reporting function
}
