% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fix_functions.R
\name{fix_NA}
\alias{fix_NA}
\title{fix_NA}
\usage{
fix_NA(
  x,
  na.strings = c("^$", "^ $", "^\\\\?$", "^-$", "^\\\\.$", "^NaN$", "^NULL$", "^N/A$"),
  track = TRUE,
  parallel = TRUE
)
}
\arguments{
\item{x}{A data.frame}

\item{na.strings}{Strings to be considered NA}

\item{track}{Track changes?}

\item{parallel}{Should the computations be performed in parallel? Set up strategy first with future::plan()}
}
\description{
Fixes miscoded missing values
}
\examples{
mydata <- data.frame(prueba = c("", NA, "A", 4, " ", "?", "-", "+"),
casa = c("", 1, 2, 3, 4, " ", 6, 7))
fix_NA(mydata)
}
