% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/fix_functions.R
\name{f_replace}
\alias{f_replace}
\title{Find and replace}
\usage{
f_replace(
  x,
  string,
  replacement,
  complete = TRUE,
  select = 1:ncol(x),
  track = TRUE
)
}
\arguments{
\item{x}{A data.frame}

\item{string}{A character string to search in the data.frame}

\item{replacement}{A character string to replace the old string (can be NA)}

\item{complete}{If TRUE, search for complete strings only. If FALSE, search also for partial strings.}

\item{select}{Numeric vector with the positions (all by default) to be affected by the function}

\item{track}{Track changes?}
}
\description{
Searches a data.frame for a specific character string and replaces it with another one
}
\examples{
iris2 <- f_replace(iris, "setosa", "ensata")
track_changes(iris2)
}
